#include "external.h"
#include "openglstuff.h"
#include "textures.h"
#include "terrain.h"
#include "particles.h"
#include "drawstuff.h"
#include "game.h"
#include <math.h>

// for debugging only
//#include <windows.h>
#include <stdio.h>
extern HillPiece **terrain;
extern int xDrawOffset;
extern int zDrawOffset;
extern double averageFPS, currentFPS;
extern int currentWallNum, currentPitNum, targetFPS, vertexNum;
extern unsigned long pointNum;
float debug1 = 0, debug2 = 0;

extern int	terrainSize;
extern UnicycleGuy guy;

extern double spacing;

GLfloat	worldScale = 1;

bool superFog = true;

double fogLength;
int screenWidth, screenHeight;

Camera		camera, debugCamera;
GLUquadricObj *quadratic;

// for fog
GLuint filter;
GLuint fogMode[] = { GL_EXP, GL_EXP2, GL_LINEAR };// Storage For Three Types Of Fog
GLuint fogfilter = 0;  // type of fog

extern int textureNum;
GLTexture *textures;

const double sqrtTwo = sqrt(2.0);
const double sqrtThree = sqrt(3.0);

GLfloat fogStart = 0.66;

GLdouble identity[16] = {1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1};
GLdouble modelviewMatrix[16];

float ambient[4] = {0.4, 0.4, 0.4, 1};
float diffuse[4] = {0.6 ,0.6 ,0.6 , 1};
float specular[4] = {1,1,1,1};
float lightPosition[4] = {1,1,1,0};

float ambient2[4] = {0.4, 0.4, 0.4, 1};
float diffuse2[4] = {0.6 ,0.6 ,0.6 , 1};
float lightPosition2[4] = {0.5,0,1,0};

	
void Camera::SetLocation(double X, double Y, double Z)
{
	x = X;
	y = Y;
	z = Z;
}

void Camera::SetRotation(double RX, double RY, double RZ)
{
	rx = RX;
	ry = RY;
	rz = RZ;
}

void Camera::Set(double X, double Y, double Z, double RX, double RY, double RZ)
{
	x = X;
	y = Y;
	z = Z;
	rx = RX;
	ry = RY;
	rz = RZ;
}

GLvoid ReSizeGLScene(GLsizei width, GLsizei height)				// Resize And Initialize The GL Window
{
	screenWidth = width;
	screenHeight = height;
	
	if (height==0)								// Prevent A Divide By Zero By
	{
		height=1;							// Making Height Equal One
	}

	glViewport(0, 0, width, height);					// Reset The Current Viewport
	
	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glLoadIdentity();							// Reset The Projection Matrix

	// Calculate The Aspect Ratio Of The Window
	gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,0.1f,1000);//terrainSize*1.5);

	glMatrixMode(GL_MODELVIEW);						// Select The Modelview Matrix
	glLoadIdentity();							// Reset The Modelview Matrix
}


int DrawGLScene(GLvoid)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glDisable(GL_STENCIL_TEST);
	
	glDepthRange(0, 0.98);
	glLoadIdentity();
	
	glScalef(worldScale,worldScale,worldScale);
	glRotatef(-camera.rx, 1,0,0);
	glRotatef(-camera.ry, 0,1,0);
	glRotatef(-camera.rz, 0,0,1);
	
	
	if (!superFog) {
		glDisable(GL_DEPTH_TEST);
		glDepthMask(false);
		
		DrawSky();
	}
	
	glEnable(GL_DEPTH_TEST);
	glDepthMask(true);
	glEnable(GL_LIGHTING);
	if (superFog)
		glDisable(GL_FOG);
	else
		glEnable(GL_FOG);
	
	
	//glScalef(-1,1,1);
	
	
	//glRotatef(90, 1,0,0);
	
	//float position[4] = {sqrt(0.4),sqrt(0.6),0,0};
	glTranslatef(-camera.x, -camera.y, -camera.z);
	
	glLightfv(GL_LIGHT0, GL_POSITION, lightPosition);
	//glLightfv(GL_LIGHT1, GL_POSITION, lightPosition2);
	
	
	//DrawUnicycleGuy(0,0,0,0,0,0);
		
	DrawWalls();
	ConstructTerrain();
	DrawTerrain();
	DrawSmilies();
	DrawPitInnards();
	/*
	if (GetKey('R')) {
		glPushMatrix();
		glLoadIdentity();
		
		glEnable(GL_STENCIL_TEST);
		glStencilFunc (GL_EQUAL, 0x1, 0x1);
		glStencilOp(GL_KEEP, GL_KEEP, GL_KEEP);
		
		glDisable(GL_DEPTH_TEST);
		glColor3f(0,0,1);
		
		glTranslatef(-1.5f,0.0f,-6.0f);
		glBegin(GL_QUADS);
			glVertex3f(-9,-9,0);
			glVertex3f(9,-9,0);
			glVertex3f(9,9,0);
			glVertex3f(-9,9,0);
		glEnd();
		
		glPopMatrix();
		glEnable(GL_DEPTH_TEST);
		glDisable(GL_STENCIL_TEST);
	}*/
	DrawUnicycleGuy(guy.x, guy.y, guy.z, guy.rx, guy.ry, guy.rz);
	
	
	glDepthMask(false);
	
	//glDisable(GL_DEPTH_TEST);
	glDepthRange(0.99, 1);
	DrawInvisiblePolygons();
	
	glDepthRange(0, 0.98);
	DrawUnicycleGuyShadow();
	
	
	
	glDepthMask(true);
	
	/*
	glColorMask(1,1,1,1);
	
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_FOG);
	glDisable(GL_DEPTH_TEST);
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_ONE_MINUS_DST_ALPHA, GL_DST_ALPHA);
	
	glLoadIdentity();
	glColor4f(1,0,0, 0.33);
	
	glBegin(GL_QUADS);
		glVertex3f(-2,-2,-1);
		glVertex3f(-2,2,-1);
		glVertex3f(2,2,-1);
		glVertex3f(2,-2,-1);
	glEnd();
	
	glDisable(GL_BLEND);
	*/
	if (superFog) {
		glPushMatrix();
		
		glTranslatef(camera.x, camera.y, camera.z);
		
		glDisable(GL_DEPTH_TEST);
		glDepthMask(false);
		
		glEnable(GL_BLEND);
		glBlendFunc(GL_ONE_MINUS_DST_ALPHA, GL_DST_ALPHA);
		
		DrawSky();
		
		glDisable(GL_BLEND);
		glDepthMask(true);
		glEnable(GL_DEPTH_TEST);
		glPopMatrix();
	}
	DrawParticles();
	
	return true;
}


int InitGL(GLvoid)
{
	GLfloat clearColor[4] = {1.0f, 1.0f, 1.0f, 0.0f};
	GLfloat fogColor[4] = {1.0f, 1.0f, 1.0f, 0.3f};
	
	glShadeModel(GL_SMOOTH);
	glClearColor(clearColor[0], clearColor[1], clearColor[2], clearColor[3]);
	glClearDepth(1.0f);
	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	glEnable(GL_TEXTURE_2D);
	
	glEnableClientState(GL_VERTEX_ARRAY);
	
	glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
	
	glEnable(GL_LIGHT0);
	glEnable(GL_COLOR_MATERIAL);
	
    GLfloat mat_specular[] = { 0,0,0,0 };
    GLfloat mat_shininess[] = { 1.0 };
	
    glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, mat_specular);
    glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, mat_shininess);
    
	
	glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse);
	glLightfv(GL_LIGHT0, GL_SPECULAR, specular);
	glLightfv(GL_LIGHT0, GL_POSITION, lightPosition); // a global variable
	
	glLightfv(GL_LIGHT1, GL_AMBIENT, ambient2);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, diffuse2);
	glLightfv(GL_LIGHT1, GL_SPECULAR, specular);
	glLightfv(GL_LIGHT1, GL_POSITION, lightPosition2); // a global variable
	
	glDisable(GL_LIGHT1);
	
	glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, GL_FALSE);
	//glEnable(GL_NORMALIZE);
	
	SetupFog(fogColor); // unimportant
	
	quadratic=gluNewQuadric();// Create A Pointer To The Quadric Object ( NEW )
	//gluQuadricNormals(quadratic, GLU_SMOOTH);// Create Smooth Normals ( NEW )
	gluQuadricTexture(quadratic, GL_TRUE);// Create Texture Coords ( NEW )
	
	
	textureNum = 13;
	textures = new GLTexture [textureNum];
	textures[0].SetTexture("grass5.bmp", GL_LINEAR_MIPMAP_NEAREST);
	textures[1].SetTexture("face.bmp", GL_LINEAR);
	textures[2].SetTexture("guybody.bmp", GL_LINEAR);
	textures[3].SetTexture("guyarm.bmp", GL_LINEAR);
	textures[4].SetTexture("wheel.bmp", "wheelmask.bmp", GL_LINEAR);
	textures[5].SetTexture("brickwall2.bmp", GL_LINEAR_MIPMAP_NEAREST);
	textures[6].SetTexture("shadow.bmp", "shadowmask.bmp", GL_LINEAR);
	textures[7].SetTexture("blank.bmp", "starmask.bmp", GL_LINEAR);
	textures[8].SetTexture("dirt.bmp", "dirtmask.bmp", GL_LINEAR);
	textures[9].SetTexture("clouds3.bmp", GL_LINEAR);
	textures[10].SetTexture("pit2.bmp", GL_LINEAR);
	textures[11].SetTexture("smiley.bmp", GL_LINEAR);
	textures[12].SetTexture("smileybig.bmp", GL_LINEAR);
	
	GLTexture **textureList = new GLTexture * [textureNum];
	for(int i = 0; i < textureNum; ++i)
		textureList[i] = &textures[i];
	
	LoadTextures(textureList, textureNum);
	
	SetupSky();
	
	CreateSmilieList();
	
	delete[] textureList;
	
	// For debugging only:
	//BuildFont();
	
	return true;								// Initialization Went OK
}

void KillGL()
{
	delete[] textures;
	//KillFont();
}

void DEBUGAdjustFog()
{
	fogfilter++;
	if (fogfilter > 2)
		fogfilter = 0;
	glFogi(GL_FOG_MODE, fogMode[fogfilter]);
}

void DrawSphere(double x, double y, double z, double r)
{
	glTranslatef(x, y, z);
	gluSphere(quadratic,r,8,8);	// Draw Our Cylinder
	glTranslatef(-x, -y, -z);
}



// for Debugging only:
/*
GLuint fontBase;
GLvoid glPrint(const char *text, int justify);
GLYPHMETRICSFLOAT gmf[256];// Storage For Information About Our Font

void glDrawText(const char *text, GLfloat x, GLfloat y, GLfloat z, GLfloat size, int align)
{
	glPushMatrix();
	glTranslatef(-x,-y,-z);
	glScalef(size,size,size);
	
	glPrint(text, align);
	
	glPopMatrix();
}

GLvoid KillFont(GLvoid)
{
	glDeleteLists(fontBase, 256);
}

GLvoid BuildFont(GLvoid)// Build Our Bitmap Font
{
	HFONT font;// Windows Font ID
	HDC temp;
	
	fontBase = glGenLists(256);// Storage For 256 Characters
	font = CreateFont(	-12,// Height Of Font
						0,// Width Of Font
						0,// Angle Of Escapement
						0,// Orientation Angle
						FW_ULTRABOLD,// Font Weight
						FALSE,// Italic
						FALSE,// Underline
						FALSE,// Strikeout
						ANSI_CHARSET,// Character Set Identifier
						OUT_TT_PRECIS,// Output Precision
						CLIP_DEFAULT_PRECIS,// Clipping Precision
						NONANTIALIASED_QUALITY,// Output Quality
						FF_DONTCARE|DEFAULT_PITCH,// Family And Pitch
						"Courier New");// Font Name
	
	temp = CreateDC("DISPLAY", NULL, NULL, NULL);
	
	SelectObject(temp, font);// Selects The Font We Created
	
	wglUseFontOutlines(	temp,// Select The Current DC
						0,// Starting Character
						255,// Number Of Display Lists To Build
						fontBase,// Starting Display Lists
						0.0f,// Deviation From The True Outlines
						0.0f,// Font Thickness In The Z Direction
						WGL_FONT_POLYGONS,// Use Polygons, Not Lines
						gmf);// Address Of Buffer To Recieve Data
	
}

GLvoid glPrint(const char *text, int justify)// Custom GL "Print" Routine
{
	float length = 0, height = 0.5;	// Used To Find The Length Of The Text
	//char text[256];		// Holds Our String
	//va_list ap;			// Pointer To List Of Arguments
	
	if (text == NULL)	// If There's No Text
		return;			// Do Nothing
	
	//va_start(ap, fmt);				// Parses The String For Variables
	//    vsprintf(text, fmt, ap);	// And Converts Symbols To Actual Numbers
	//va_end(ap);						// Results Are Stored In Text
	for (unsigned int loop = 0;loop < (strlen(text)); loop++)	// Loop To Find Text Length
	{
		length+=gmf[text[loop]].gmfCellIncX;	// Increase Length By Each Characters Width
	}
		
	switch(justify) {
		case 0:
			glTranslatef(-length/2,-height/2,0.0f);	// Center Our Text On The Screen
			break;
		case 1:
			glTranslatef(-length,-height/2,0.0f);	// Center Our Text On The Screen
			break;
		case 2:
			glTranslatef(0,-height/2,0.0f);	// Center Our Text On The Screen
			break;
	}
	
	//glPushAttrib(GL_LIST_BIT);// Pushes The Display List Bits
	glListBase(fontBase);// Sets The Base Character to 0
	
	glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);// Draws The Display List Text
	//glPopAttrib();// Pops The Display List Bits
}


GLvoid BuildFont(GLvoid)								// Build Our Bitmap Font
{
	HFONT	font;										// Windows Font ID
	HFONT	oldfont;									// Used For Good House Keeping
	HDC hDC;
	
	base = glGenLists(96);								// Storage For 96 Characters

	font = CreateFont(	-12,							// Height Of Font
						0,								// Width Of Font
						0,								// Angle Of Escapement
						0,								// Orientation Angle
						FW_BOLD,						// Font Weight
						FALSE,							// Italic
						FALSE,							// Underline
						FALSE,							// Strikeout
						ANSI_CHARSET,					// Character Set Identifier
						OUT_TT_PRECIS,					// Output Precision
						CLIP_DEFAULT_PRECIS,			// Clipping Precision
						ANTIALIASED_QUALITY,			// Output Quality
						FF_DONTCARE|DEFAULT_PITCH,		// Family And Pitch
						"Courier New");					// Font Name

	hDC = CreateDC("DISPLAY", NULL, NULL, NULL);

	oldfont = (HFONT)SelectObject(hDC, font);           // Selects The Font We Want
	wglUseFontBitmaps(hDC, 32, 96, base);				// Builds 96 Characters Starting At Character 32
	SelectObject(hDC, oldfont);							// Selects The Font We Want
	DeleteObject(font);									// Delete The Font
}

GLvoid KillFont(GLvoid)									// Delete The Font List
{
	glDeleteLists(base, 96);							// Delete All 96 Characters
}

GLvoid glPrint(const char *fmt, ...)					// Custom GL "Print" Routine
{
	char		text[256];								// Holds Our String
	va_list		ap;										// Pointer To List Of Arguments

	if (fmt == NULL)									// If There's No Text
		return;											// Do Nothing

	va_start(ap, fmt);									// Parses The String For Variables
	    vsprintf(text, fmt, ap);						// And Converts Symbols To Actual Numbers
	va_end(ap);											// Results Are Stored In Text

	glPushAttrib(GL_LIST_BIT);							// Pushes The Display List Bits
	glListBase(base - 32);								// Sets The Base Character to 32
	glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);	// Draws The Display List Text
	glPopAttrib();										// Pops The Display List Bits
}
*/

void DoDebuggingStuff()
{
	double y = -4.2, dy = 0.2, size = 0.25;
	FILE *file;
	
	file = fopen("debug.txt", "wb");
	if (file == NULL || ferror(file) != 0) return;
	
	fprintf(file, "guy.x: %f\n", guy.x);
	fprintf(file, "guy.z: %f\n", guy.z);
	fprintf(file, "afps: %f\n", averageFPS);
	fprintf(file, " fps: %f\n", currentFPS);
	fprintf(file, "camera.x: %f\n", camera.x);
	fprintf(file, "camera.y: %f\n", camera.y);
	fprintf(file, "camera.z: %f\n", camera.z);
	fprintf(file, "debug1: %f\n", debug1);
	fprintf(file, "debug2: %f\n", debug2);
	
	fclose(file);
	
	
	/*
	glLoadIdentity();
	glDisable(GL_DEPTH_TEST);
	glTranslatef(0.0f,0.0f,-0.2f);						// Move One Unit Into The Screen
	
	
	sprintf(buffer, "guy.x: %f", guy.x);
	glDrawText(buffer, 5.3, y+=dy, 10, size, 2);
	
	sprintf(buffer, "guy.z: %f", guy.z);
	glDrawText(buffer, 5.3, y+=dy, 10, size, 2);
	
	sprintf(buffer, "afps: %f", averageFPS);
	glDrawText(buffer, 5.3, y+=dy, 10, size, 2);
	
	sprintf(buffer, " fps: %f", currentFPS);
	glDrawText(buffer, 5.3, y+=dy, 10, size, 2);
	
	sprintf(buffer, "vertex#: %d", vertexNum);
	glDrawText(buffer, 5.3, y+=dy, 10, size, 2);
	
	sprintf(buffer, "point#: %d", pointNum);
	glDrawText(buffer, 5.3, y+=dy, 10, size, 2);
	
	/*
	GetOffsetCoords(xdo,zdo);
	
	sprintf(buffer, "xdo: %f", xdo);
	glDrawText(buffer, 5.3, y+=dy, 10, size, 2);
	
	sprintf(buffer, "zdo: %f", zdo);
	glDrawText(buffer, 5.3, y+=dy, 10, size, 2);
	sprintf(buffer, "camera.x: %f", camera.x);
	glDrawText(buffer, 5.3, y+=dy, 10, size, 2);
	
	sprintf(buffer, "camera.y: %f", camera.y);
	glDrawText(buffer, 5.3, y+=dy, 10, size, 2);
	
	sprintf(buffer, "camera.z: %f", camera.z);
	glDrawText(buffer, 5.3, y+=dy, 10, size, 2);
	
	sprintf(buffer, "targetCamera.x: %f", debugCamera.x);
	glDrawText(buffer, 5.3, y+=dy, 10, size, 2);
	
	sprintf(buffer, "targetCamera.y: %f", debugCamera.y);
	glDrawText(buffer, 5.3, y+=dy, 10, size, 2);
	
	sprintf(buffer, "targetCamera.z: %f", debugCamera.z);
	glDrawText(buffer, 5.3, y+=dy, 10, size, 2);
	
	glEnable(GL_DEPTH_TEST);*/
}



void CalculateNormalVector(	double x1, double y1, double z1,
							double x2, double y2, double z2, 
							double x3, double y3, double z3, 
							double &rx, double &ry, double &rz)
{
	double Ax, Ay, Az, Bx, By, Bz, d;
	
	Ax = x1-x2;
	Ay = y1-y2;
	Az = z1-z2;
	
	Bx = x2-x3;
	By = y2-y3;
	Bz = z2-z3;
	
	rx = Ay*Bz - Az*By;
	ry = Az*Bx - Ax*Bz;
	rz = Ax*By - Ay*Bx;
	
	d = sqrt(rx*rx + ry*ry + rz*rz);
	
	rx /= d;
	ry /= d;
	rz /= d;
}

void GetProjection()
{
	glGetDoublev(GL_MODELVIEW_MATRIX, modelviewMatrix);
}

void glVertex3fWithSuperFog(GLfloat x, GLfloat y, GLfloat z)
{
	if (superFog)
		SuperFog(x,y,z,1,1,1);
	glVertex3f(x,y,z);
}

void SuperFog(GLfloat x, GLfloat y, GLfloat z, GLfloat r, GLfloat g, GLfloat b)
{
	GLdouble newX, newY, newZ;
	bool *keys = GetKeys();
	int what[] = {0,0,0,0};
	
	if (keys['f'])
		x = x;
	
	newX = modelviewMatrix[0]*x + modelviewMatrix[4]*y + modelviewMatrix[8]*z + modelviewMatrix[12];
	newY = modelviewMatrix[1]*x + modelviewMatrix[5]*y + modelviewMatrix[9]*z + modelviewMatrix[13];
	newZ = modelviewMatrix[2]*x + modelviewMatrix[6]*y + modelviewMatrix[10]*z + modelviewMatrix[14];
	
	//gluProject(x,y,z, modelviewMatrix, identity, what, &newX, &newY, &newZ);
	
	/*newX *= 2.5;
	newY *= 2.5;
	newZ *= 2.5;*/
	newX += camera.x;
	newY += camera.y;
	newZ += camera.z;
	
	glColor4f(r,g,b, calculateFog(newX, newY, newZ));
}


GLfloat calculateFog(GLfloat x, GLfloat y, GLfloat z)
{
	GLfloat dx, dz, d, a;
	
	y = y;
	dx = x-camera.x;
	dz = z-camera.z;
	
	d = sqrt(dx*dx+dz*dz);
	
	a = (fogLength-d) / (fogLength-(fogLength*fogStart));
	
	if (a < 0)
		a = 0;
	else if (a > 1)
		a = 1;
	
	return a;
}


void SetupFog(float *clearColor)
{
	fogStart = 0.75;
	fogLength = terrainSize*0.95;
	glFogi(GL_FOG_MODE, GL_LINEAR);//fogMode[fogfilter]);// Fog Mode  GL_EXP GL_EXP2 or GL_LINEAR
	glFogf(GL_FOG_START, (terrainSize*0.45) * fogStart);
	glFogf(GL_FOG_END, (terrainSize*0.45));
	//glFogf(GL_FOG_START, 8);// Fog Start Depth
	//glFogf(GL_FOG_END, 10);// Fog End Depth
	glFogfv(GL_FOG_COLOR, clearColor);// Set Fog Color
	glFogf(GL_FOG_DENSITY, 0.9f);// How Dense Will The Fog Be
	glHint(GL_FOG_HINT, GL_DONT_CARE);// Fog Hint Value
}
